/*
 * Decompiled with CFR 0.152.
 */
package org.quantumclient.energy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ForkJoinPool;
import org.quantumclient.energy.Event;
import org.quantumclient.energy.IEventBus;
import org.quantumclient.energy.Listener;
import org.quantumclient.energy.Subscribe;

public class EventBus
implements IEventBus {
    private final Map<Class<? extends Event>, CopyOnWriteArrayList<Listener>> listeners = new ConcurrentHashMap<Class<? extends Event>, CopyOnWriteArrayList<Listener>>();

    @Override
    public void register(Object registerClass) {
        for (Method method : registerClass.getClass().getMethods()) {
            Class<?> event;
            if (!method.isAnnotationPresent(Subscribe.class) || method.getParameterCount() != 1) continue;
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            if (!this.listeners.containsKey(event = method.getParameterTypes()[0])) {
                this.listeners.put(event, new CopyOnWriteArrayList());
            }
            this.listeners.get(event).add(new Listener(registerClass, method));
        }
    }

    @Override
    public void unregister(Object registerClass) {
        for (CopyOnWriteArrayList<Listener> arrayList : this.listeners.values()) {
            arrayList.removeIf(listener -> listener.getListenerClass().equals(registerClass));
        }
    }

    @Override
    public void post(Event event) {
        List listenersList = this.listeners.get(event.getClass());
        if (listenersList != null) {
            for (Listener listener : listenersList) {
                if (event.isCancelled()) {
                    return;
                }
                try {
                    listener.getMethod().invoke(listener.getListenerClass(), event);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public synchronized void mutliThreadPost(Event event) {
        List listenersList = this.listeners.get(event.getClass());
        if (listenersList != null) {
            for (Listener listener : listenersList) {
                if (event.isCancelled()) {
                    return;
                }
                ForkJoinPool.commonPool().submit(() -> {
                    try {
                        listener.getMethod().invoke(listener.getListenerClass(), event);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        e.printStackTrace();
                    }
                });
            }
        }
    }
}

