/*
 * Decompiled with CFR 0.152.
 */
package org.utilitymods.friendapi;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.utilitymods.friendapi.Affinity;
import org.utilitymods.friendapi.ApiFailedException;

public class BaseProfile {
    public String name;
    public UUID uuid;
    public Affinity affinity;
    @SerializedName(value="data")
    protected Map<String, Object> dataMap = new ConcurrentHashMap<String, Object>();

    public BaseProfile(@NotNull String name, @NotNull UUID uuid, @NotNull Affinity affinity) {
        this.name = name;
        this.uuid = uuid;
        this.affinity = affinity;
    }

    public BaseProfile(@NotNull String name, @NotNull UUID uuid) {
        this.name = name;
        this.uuid = uuid;
        this.affinity = Affinity.FRIEND;
    }

    public boolean addData(String key, Object data) {
        if (this.dataMap.containsKey(key)) {
            return false;
        }
        this.dataMap.compute(key, (key1, data1) -> {
            data1 = data;
            return data1;
        });
        return true;
    }

    public Object getData(String key) {
        return this.dataMap.get(key);
    }

    public static BaseProfile fromUsername(String username, Affinity affinity) throws ApiFailedException {
        try {
            URL url = new URL("https://api.mojang.com/users/profiles/minecraft/" + username);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            JsonObject jsonObject = new JsonParser().parse((Reader)new InputStreamReader(conn.getInputStream())).getAsJsonObject();
            UUID uuid = UUID.fromString(jsonObject.get("id").getAsString().replaceFirst("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)", "$1-$2-$3-$4-$5"));
            String name = jsonObject.get("name").getAsString();
            return new BaseProfile(name, uuid, affinity);
        }
        catch (Exception e) {
            throw new ApiFailedException("no uuid associated with " + username);
        }
    }

    public static BaseProfile fromUuid(UUID uuid, Affinity affinity) throws ApiFailedException {
        try {
            URL url = new URL("https://api.mojang.com/user/profiles/" + uuid.toString() + "/names");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            JsonArray jsonArray = new JsonParser().parse((Reader)new InputStreamReader(conn.getInputStream())).getAsJsonArray();
            String name = jsonArray.get(jsonArray.size() - 1).getAsJsonObject().get("name").getAsString();
            return new BaseProfile(name, uuid, affinity);
        }
        catch (Exception e) {
            throw new ApiFailedException("no username associated with uuid:" + uuid);
        }
    }

    public String toString() {
        return "Name: " + this.name + "\nUuid: " + this.uuid + "\nAffinity: " + (Object)((Object)this.affinity) + "\n";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseProfile baseProfile = (BaseProfile)obj;
        if (this.name == null ? baseProfile.name != null : !this.name.equals(baseProfile.name)) {
            return false;
        }
        if (this.uuid == null ? baseProfile.uuid != null : !this.uuid.equals(baseProfile.uuid)) {
            return false;
        }
        return !(this.affinity == null ? baseProfile.affinity != null : !this.affinity.equals((Object)baseProfile.affinity));
    }
}

