/*
 * Decompiled with CFR 0.152.
 */
package org.utilitymods.friendapi;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.utilitymods.friendapi.Affinity;
import org.utilitymods.friendapi.ApiFailedException;
import org.utilitymods.friendapi.BaseProfile;
import org.utilitymods.friendapi.serialization.MapAdapter;

public final class FriendManager {
    private static final String VERSION = "1.0.0";
    private static final Logger LOGGER = LogManager.getLogger((String)"FriendAPI");
    public static final FriendManager INSTANCE = new FriendManager();
    private ConcurrentHashMap<UUID, BaseProfile> FRIENDS = new ConcurrentHashMap();
    public final Gson GSON = new GsonBuilder().enableComplexMapKeySerialization().registerTypeHierarchyAdapter(Map.class, (Object)new MapAdapter()).setPrettyPrinting().create();
    private final Type type = new TypeToken<ConcurrentHashMap<UUID, BaseProfile>>(){}.getType();
    private final File FILE = new File(System.getProperty("user.home"), ".friends.json");

    public FriendManager() {
        long start = System.currentTimeMillis();
        LOGGER.info("Using FriendAPI 1.0.0");
        this.load();
        Runtime.getRuntime().addShutdownHook(new Thread(this::save));
        LOGGER.info("FriendAPI started in " + (System.currentTimeMillis() - start) + "ms");
    }

    public void load() {
        try {
            if (!this.FILE.exists()) {
                this.save();
            }
            if (this.FILE.exists()) {
                BufferedReader reader = Files.newBufferedReader(this.FILE.toPath());
                ConcurrentHashMap tempList = (ConcurrentHashMap)this.GSON.fromJson((Reader)reader, this.type);
                if (tempList != null) {
                    this.FRIENDS.putAll(tempList);
                }
                ((Reader)reader).close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.fatal("Failed to load \"" + this.FILE.getAbsolutePath() + "\"!");
        }
    }

    public void save() {
        try {
            OutputStreamWriter output = new OutputStreamWriter((OutputStream)new FileOutputStream(this.FILE), StandardCharsets.UTF_8);
            output.write(this.GSON.toJson(this.FRIENDS));
            output.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @NotNull
    public Map<UUID, BaseProfile> getFriendMapCopy() {
        return Collections.unmodifiableMap(this.FRIENDS);
    }

    @NotNull
    public List<BaseProfile> getOnlyFriendsProifles() {
        return this.getFriendMapCopy().values().stream().filter(profile -> profile.affinity == Affinity.FRIEND).collect(Collectors.toList());
    }

    @NotNull
    public BaseProfile getFriend(@NotNull UUID uuid) {
        return this.FRIENDS.computeIfAbsent(uuid, k -> new BaseProfile("empty", uuid, Affinity.NEUTRAL));
    }

    public BaseProfile addFriend(BaseProfile profile) {
        return this.FRIENDS.compute(profile.uuid, (uuid, profile1) -> {
            profile1 = profile;
            return profile1;
        });
    }

    public void removeFriend(@NotNull UUID uuid) {
        this.FRIENDS.remove(uuid);
    }

    @NotNull
    public Affinity getAffinity(@NotNull UUID uuid) {
        return this.getFriend((UUID)uuid).affinity;
    }

    public boolean isFriend(@NotNull UUID uuid) {
        return this.getAffinity((UUID)uuid).type == Affinity.FRIEND.type;
    }

    public boolean isEnemy(@NotNull UUID uuid) {
        return this.getAffinity(uuid) == Affinity.ENEMY;
    }

    public boolean isNeutral(@NotNull UUID uuid) {
        return this.getAffinity((UUID)uuid).type < 2;
    }

    public void migrateFromNameList(List<String> nameList) {
        nameList.forEach(name -> {
            try {
                this.addFriend(BaseProfile.fromUsername(name, Affinity.FRIEND));
            }
            catch (ApiFailedException e) {
                e.printStackTrace();
            }
        });
    }

    public void migrateFromUuidList(List<UUID> nameList) {
        nameList.forEach(uuid -> {
            try {
                this.addFriend(BaseProfile.fromUuid(uuid, Affinity.FRIEND));
            }
            catch (ApiFailedException e) {
                e.printStackTrace();
            }
        });
    }
}

